/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef lx_routing_h
#define lx_routing_h

#ifdef	__cplusplus
extern "C"
{
#if 0
}
#endif
#endif

enum
{
  LX_ROUTING_RANDOM,
  LX_ROUTING_NEXT,
  LX_ROUTING_LEAST
};

int lx_routing_set_routes (lx_map_t*m, int iport, int index);
int lx_routing_number_xbars_clos (lx_map_t*m, int*num_spines);
void lx_routing_shuffle_ports (int ports [LX_XBAR_SIZE]);
void lx_routing_sort_ports (lx_map_t*m, int ports [LX_XBAR_SIZE], lx_node_t*n);
int lx_routing_careful_routes (lx_map_t*m, int iport, lx_node_t*me, int seek_size, int order, int shortest);
void lx_routing_forget (lx_map_t*m);
int lx_routing_shortest_path (lx_map_t*m, int iport, lx_node_t*me, int updown);

#ifdef __cplusplus
#if 0
{
#endif
}
#endif

#endif /*lx_routing_h*/
